import { Router } from 'express';
import { withdrawalsController } from './controller';
import { authenticateUser, requireVendor, requireAdmin } from '@/middlewares/auth';
import { vendorService } from '@/modules/vendors/service';

const router = Router();

// Attach vendor to req for downstream use
async function attachVendor(req: any, res: any, next: any) {
  if (req.user) {
    const { data: vendor } = await vendorService.getVendorByUserId(req.user.id);
    req.vendor = vendor || null;
  }
  next();
}

// Attach admin to req for downstream use (simulate admin extraction)
async function attachAdmin(req: any, res: any, next: any) {
  req.admin = req.user; // Assume admin is authenticated user for now
  next();
}

// Vendor: view withdrawal history and wallet summary
router.get('/', authenticateUser, requireVendor, attachVendor, withdrawalsController.history);
// Vendor: update bank account
router.patch('/vendors/bank-account', authenticateUser, requireVendor, attachVendor, withdrawalsController.updateBankAccount);
// Admin: pause/resume withdrawals for vendor
router.patch('/admin/vendors/:id/withdrawal-status', authenticateUser, requireAdmin, attachAdmin, withdrawalsController.updateVendorWithdrawalStatus);
// Admin: pause/resume withdrawals globally
router.patch('/admin/withdrawals/global-status', authenticateUser, requireAdmin, attachAdmin, withdrawalsController.updateGlobalWithdrawalStatus);
// Admin: manual trigger of withdrawal job
router.post('/admin/withdrawals/trigger', authenticateUser, requireAdmin, attachAdmin, withdrawalsController.triggerWithdrawalJob);

export default router; 